# delimit ;  set more 1 ; 
capture log close;

*global folder "C:\research";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "~/";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
global folder "D:\Dropbox\";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;


         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
	 	 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";

log using `saved'income.log, replace ; 
clear;
set memory 300m;
program drop _all;
set more off;

program define _getid_;
     version 6.0;
     gen temp=real(HHID);
     drop HHID;
     gen HHID=temp;
     replace temp=real($SUBHH);
     drop $SUBHH;
     gen $SUBHH=temp;
     replace temp=real(PN);
     drop PN;
     gen PN=temp;
     drop temp;
     end;

program define _getid2_;
     version 6.0;
     gen temp=real(HHID);
     drop HHID;
     gen HHID=temp;
     replace temp=real($SUBHH);
     drop $SUBHH;
     gen $SUBHH=temp;
     drop temp;
     end;
****************************************************************;
* WHAT’S IN THIS FILE ------------------------------------------;
* NOTE FOR ALL WAVES: SELF-EMPLOYMENT INCOME IS NOT IN HERE     ;
* faminc: TOTAL FAMILY INCOME                                   ;
* LABY: LABOR INCOME                                            ;
* SELFY: SELF EMPLOYMENT                                        ;
* CAPY: CAPITAL INCOME                                          ;
* the components of CAPY ARE CAPY =businc+interestinc+royaltyinc;
* businc: INCOME FROM BUSINESSES YOU OWN, BUT DO NOT MANAGE     ;
* interestinc: interest, rent, dividends                        ;
* royaltyinc: royalties & trust income                          ;
* PENY: PENSIONS                                                ;
* COMPONENTS OF PENY ARE: PENY= peninc + anninc                 ;
* peninc: PENSIONS FROM FIRMS, VA                               ; 
* VAinc: VA benefits                                            ;
* anninc: PRIVATE ANNUITY INCOME                                ;
* SOCY = Socialinc +DIinc                                       ;
* DIinc: DI                                                     ;
* Socialinc: SOCIAL SECURITY INCOME, NOT DI (INCLUDES SURVIVOR BENES);
* OTHY=OTHER INCOME, MOSTLY SOCIAL INSURANCE                    ;
* COMPONENTS OF OTHY ARE: OTHY= unempinc+ SSIinc                ;
* unempinc=: UNEMPLOYMENT AND WORKERS COMP                      ;
* SSIinc: SSI
* WELFAREinc: WELAFRE                                           ;
* NOTES:--------------------------------------------------------;
* DI IS MISSING FOR SOME WAVES                                  ;
* see the bottom of this file for suggestions for how to get it straight;
* AHEAD WAVE 1                                                  ;
* SOME VARIABLES I DO NOT USE                                   ;
* * otherinc: alimony/child support, income from relatives/friends;
* 'other' Social Security income, 'other' VA income, “OTHER”    ;
****************************************************************;



************************** HRS WAVE I **************************;


clear;
use `wave1d'househld.dta;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
sort HHID;
merge 1:1 HHID using `wave1d'h92i_n.dta;
drop _merge;

gen faminc1= V6559-V6558; //Deduct income of other household members;
gen SELFY1=.;*V5905;
*replace SELFY1=0 if V5905==.;
* it is not clear how to obtain this value--the hrs people don't seem to know;
* should be put in information from V2825 and V2828?  maybe, but it seems best to leave;
* self-employment income as missing ;
gen LABY1=V6550+V6551;
gen CAPY1=V6555;
* generate the components of capy;
gen businc1=V5905;
replace businc1=0 if V5905==. & CAPY1~=.;
* interest, rent, dividends;
replace V5907=0 if V5907==. & CAPY1~=.;
replace V5909=0 if V5909==. & CAPY1~=.;
replace V5911=0 if V5911==. & CAPY1~=.;
gen interestinc1=V5907+V5909+V5911;
replace V5913=0 if V5913==. & CAPY1~=.;
rename V5913 royaltyinc1; * royalties & trust income;
gen capinc1=businc1+interestinc1+royaltyinc1;
sum capinc1 CAPY1;

gen peninc1= V6560+V6561+V6562+V6563;
gen VAinc1 = V6563; 
gen Socialinc1= V6564;
gen anninc1=V6566;

gen PENY1= peninc1+ anninc1;
gen unempinc1=V6552;
gen SSIinc1=V5803X+V5823X; //may not work here
*gen SSIinc1=V6554;
gen WELFAREinc1=V5903X;
gen DIinc1=V6556;
gen otherinc1=V6557;

gen SOCY1=Socialinc1+DIinc1;

gen OTHY1=V6552+V6554; //will be different from future waves
gen HHINCST1= LABY1+CAPY1+PENY1+OTHY1;
gen DIF1=faminc1-HHINCST1;

gen penan1= peninc1+ Socialinc1+anninc1;
gen PEND1=penan1-V6553; 

destring APN_FIN, gen(PN);

keep faminc1 SELFY1 SOCY1 LABY1 CAPY1 businc1 interestinc1 royaltyinc1 PENY1 peninc1 Socialinc1 anninc1 OTHY1 PENY1 unempinc1 SSIinc1 WELFAREinc1 VAinc1 DIinc1 otherinc1
DIF1 PEND1 HHID ASUBHH PN;
summ;
drop PEND1 DIF1;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE II **************************;

use `wave2d'W2a.dta; // get PN variable from the file;
destring CSUBHH, gen(W2SUBHH);
gen temp=real(HHID);
drop HHID;
rename temp HHID;
sort HHID W2SUBHH;
save `wave2d'temp, replace;
drop _all;

use `wave2d'W2n.dta; // get DI info from the file;
destring CSUBHH, gen(W2SUBHH);
gen temp=real(HHID);
drop HHID;
rename temp HHID;
sort HHID W2SUBHH;
save `wave2d'temPN, replace;
drop _all;


use `wave2d'H94i_n.dta;
sort HHID W2SUBHH ;
merge HHID W2SUBHH using `wave2d'temp;
drop _merge;

sort HHID W2SUBHH ;
merge HHID W2SUBHH using `wave2d'temPN;
drop _merge;

gen faminc2=WHHINC;
* NOTE: SELF-EMPLOYMENT INCOME IN WAVE 2;
gen SELFY2= W5901X; *JON: W5901Z was not in the updated dataset so I changed this to W5901X.;

gen LABY2=W5913X+W5919X+W5925X+W5931X+W5937X+W5943X+W5949X+W5955X+W5961X+W5967X+W5973X+W5979X;

gen CAPY2=W5907X+W6288X+W6296X+W6302X;*JON: This was W5907Z but Z was not available in the updated data, so I used X.;
* generate the components of capy;
gen businc2= W5907X;
* interest, rent, dividends;
gen interestinc2= W6288X+W6296X;
rename W6302X royaltyinc2; * royalties & trust income;
gen capinc2=businc2+interestinc2+royaltyinc2;
sum capinc2 CAPY2;

gen anninc2=(W6118Z+W6126Z+W6138Z+W6146Z);
gen peninc2=(W6063Z+W6067Z+W6075Z+W6083Z+W6095Z+W6103Z);
gen VAinc2 = W6063Z+W6067Z;
gen Socialinc2=0;
replace Socialinc2=W6260Z if W6255~=2;
replace Socialinc2=Socialinc2+W6268Z if W6263~=2;
gen DIinc2=0;
replace DIinc2=W6260Z if W6255==2;
replace DIinc2=DIinc2+W6268Z if W6263~=2;

gen PENY2=peninc2+anninc2;
gen SOCY2=DIinc2+ Socialinc2;


gen unempinc2= W5986X+W6003X+ W6022X + W6039X;
gen SSIinc2=W6204Z; 
gen WELFAREinc2= W6286X;
gen otherinc2= W6306X+W6308X + W6304X;
gen OTHY2= unempinc2+ SSIinc2 + WELFAREinc2;
gen HHINCST2=LABY2+CAPY2+PENY2+OTHY2; * NOTE: adding W5901Z largely reconciles the problem;
gen DIF2=faminc2-HHINCST2;

keep faminc2 SELFY2 SOCY2 LABY2 CAPY2 businc2 interestinc2 royaltyinc2 PENY2 peninc2 Socialinc2 anninc2 OTHY2 PENY2 unempinc2 SSIinc2 WELFAREinc2 VAinc2 DIinc2 otherinc2
DIF2 HHID PN W2SUBHH;

summ;
drop DIF2;
destring PN, replace;
sort HHID PN;
merge HHID PN using `saved'income;
drop _merge;


sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;


************************** HRS WAVE III **************************;

use `wave3d'H96a_r.dta; * get PN variable from the file;
global SUBHH "ESUBHH";
_getid_;
sort HHID ESUBHH;
save `wave3d'temp, replace;
drop _all;

use `wave3d'h96i_jh.dta;
global SUBHH "ESUBHH";
_getid2_;
sort HHID ESUBHH ;
merge HHID ESUBHH using `wave3d'temp;
drop _merge;

gen faminc3= EHHINC;
gen SELFY3=E3876X + E3909X; * self-employment income;
gen LABY3=E3883X+E3916X+E3890X+E3923X+E3897X+E3930X+E3903X+E3936X;


gen otherassinc3= E4519X; * income from “other assets” (does not match up with previous waves); 


* generate the components of capy;
* interest, rent, dividends;

gen interestinc3=E4089X; * rent;
replace interestinc3=interestinc3+ E4362X +E4405X+E4445X +E4487X; *interest+dividends;
gen businc3= E4117Z;

gen royaltyinc3= E4564X; 
gen CAPY3=businc3+interestinc3+royaltyinc3;



gen otherinc3= E4575X; * other income (but includes rent, private DI;
       *, which is inconsistent with other waves); 
replace otherinc3=otherinc3+E4568X; * alimony;

* NOTE: E4138Z +E4159Z+E4178Z =IRA withdraw, which I do not think is capital income;

gen peninc3=E4214_1Z+E4214_2Z +E4232X +E4237_1Z+E4237_2Z +E4043Z+E4056Z;
gen VAinc3=E4043Z+E4056Z;
gen anninc3= E4269_1Z+E4269_2Z +E4291X +E4298_1Z+E4298_2Z+ E4320X;
gen Socialinc3 =E3985Z+ E3996Z;
  
gen PENY3=peninc3+anninc3;

gen SSIinc3= E4023Z; 
gen WELFAREinc3= E4038X;
gen unempinc3= E3944X+E3952X+E3963X+E3974X; 
gen DIinc3=0; * where is this variable?;
gen SOCY3= DIinc3+Socialinc3;
gen OTHY3= unempinc3+ SSIinc3 +WELFAREinc3;
gen HHINCST3=LABY3+CAPY3+PENY3+OTHY3;
gen DIF3=faminc3-HHINCST3;

keep faminc3 DIF3 SELFY3 SOCY3 LABY3 CAPY3 PENY3 OTHY3 HHID PN 
faminc3 LABY3 CAPY3 businc3 interestinc3 royaltyinc3 PENY3 peninc3 Socialinc3 anninc3 OTHY3 PENY3 unempinc3 SSIinc3 WELFAREinc3 VAinc3 DIinc3 otherinc3
DIF3 HHID PN ESUBHH;
summ;
drop DIF3;
sort HHID PN;
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE IV **************************;

use `wave4d'H98i_jh.dta;



global SUBHH "FSUBHH";
_getid_;
gen faminc4= FHHINC;
renpfix F Q;
rename QSUBHH FSUBHH;
rename QHHINC FHHINC;
gen SELFY4=Q4634X +Q4670X; 
gen LABY4= Q4643X+Q4676X+Q4652X+Q4683X +Q4658X+Q4690X+ Q4664X+Q4696X;

gen otherassinc4= Q5283X; * income from “other assets” (does not match up with previous waves, but same as in wave 3); 


* generate the components of capy;
* interest, rent, dividends;

gen interestinc4= Q4849X; * rent;
replace interestinc4=interestinc4+Q5122X+Q5165X+Q5205X+Q5247X; *interest+dividends;
gen businc4= Q4877X;
gen royaltyinc4= Q5324X; 
gen CAPY4=businc4+interestinc4+royaltyinc4;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
*Q4898Z +Q4919Z+Q4938Z:IRA withdraw, which is not capital income;
* Q4949Z:IRA annuity conversion, which is not capital income;

gen peninc4= Q4803Z+Q4816Z +Q4974_1Z +Q4974_2Z+Q4997_1Z+Q4997_2Z;

sum peninc4 Q4803Z Q4816Z Q4974_1Z Q4974_2Z Q4997_1Z Q4997_2Z;

gen VAinc4= Q4803Z+Q4816Z;


gen anninc4= Q5029_1Z+Q5029_2Z+Q5058_1Z+Q5058_2Z;

gen Socialinc4 = Q4745Z+Q4756Z;* note: these are total benes, includes DI;
gen PENY4=peninc4+anninc4;




gen SSIinc4= Q4783Z;
gen WELFAREinc4= Q4798X;
gen unempinc4= Q4704X+Q4712X+Q4723X +Q4734X; 
gen DIinc4=0; * where is this variable?;
gen otherinc4=Q5328X+Q5335X; * the “other income” variable is the same as in wave 3;
gen SOCY4= DIinc4+ Socialinc4;

gen OTHY4= unempinc4+ SSIinc4 + WELFAREinc4;

gen HHINCST4=LABY4+CAPY4+PENY4+OTHY4;
gen DIF4=faminc4-HHINCST4;

keep 
faminc4 SELFY4 LABY4 SOCY4 CAPY4 businc4 interestinc4 royaltyinc4 PENY4 peninc4 Socialinc4 anninc4 OTHY4 PENY4 unempinc4 SSIinc4 WELFAREinc4 VAinc4 DIinc4 otherinc4
DIF4 HHID PN FSUBHH;
summ;
drop DIF4;
sort HHID PN;
merge 1:1 HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE V **************************;

use `wave5d'H00i_jh.dta;
global SUBHH "GSUBHH";
_getid_;
gen faminc5=GHHINC;
renpfix G Q;
rename QSUBHH GSUBHH;
rename QHHINC GHHINC;
gen SELFY5= Q5073X+ Q5109X ;
gen LABY5= Q5082X+Q5115X+Q5091X+Q5122X+Q5097X+Q5129X+Q5103X+Q5135X;

gen otherassinc5= Q5704X; * income from “other assets” (does not match up with previous waves, but same as in wave 3); 


* generate the components of capy;
* interest, rent, dividends;

gen interestinc5= Q5294X; * rent;
replace interestinc5=interestinc5+Q5572X+Q5606X +Q5640X+Q5668X; *interest+dividends;
gen businc5= Q5322X ;
gen royaltyinc5= Q5718X; 
gen CAPY5=businc5+interestinc5+royaltyinc5;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
* Q5343Z+Q5364Z+Q5383Z: IRA withdraws;
* Q5397Z: IRA rolled over into an annuity;

gen peninc5= Q5248Z+Q5261Z+Q5429_1Z+Q5429_2Z +Q5452_1Z+Q5452_2Z; * note: Q5473
 should be included, but the mean of it is close to 0;
 
gen VAinc5 = Q5248Z+Q5261Z;

gen anninc5=Q5484_1Z+Q5484_2Z+Q5513_1Z+Q5513_2Z; * note: Q5506 should be included, but the mean of it is close to 0;

gen Socialinc5 = Q5186Z+Q5199Z;* note: these are total benes, includes DI;
gen PENY5=peninc5+anninc5;

gen SSIinc5= Q5226Z; 
gen WELFAREinc5= Q5241X;
gen unempinc5= Q5143X+Q5151X+Q5162X+Q5173X; 
gen DIinc5=0; * where is this variable?;
gen otherinc5= Q5722X+Q5729X; * the “other income” variable is the same as in wave 4;
gen SOCY5= DIinc5+Socialinc5;

gen OTHY5= unempinc5+ SSIinc5 + WELFAREinc5;

gen HHINCST5=LABY5+CAPY5+PENY5+OTHY5;
gen DIF5=faminc5-HHINCST5;

keep 
faminc5 SELFY5 LABY5 SOCY5 CAPY5 businc5 interestinc5 royaltyinc5 PENY5 peninc5 Socialinc5 anninc5 OTHY5 PENY5 unempinc5 SSIinc5 WELFAREinc5 VAinc5 DIinc5 otherinc5
DIF5 HHID PN GSUBHH;

summ;
drop DIF5;
sort HHID PN;
merge 1:1 HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE VI **************************;


use `wave6d'H02A_R.dta; * get PN variable from the file;
global SUBHH "HSUBHH";
_getid_;
sort HHID HSUBHH;
egen group= group(HHID HSUBHH);
sort group;
by group: gen num=_N;
gen temp2=1;
replace temp2=0 if num==2 & (HFINR~=1);
sort HHID HSUBHH temp2;
save `wave6d'temp, replace;
drop _all;


use `wave6d'H02i_qh.dta;
gen temp2=1;
global SUBHH "HSUBHH";
_getid2_;
sort HHID HSUBHH temp2;
merge 1:1 HHID HSUBHH temp2 using `wave6d'temp;
drop _merge temp2;


gen faminc6=HHHINC;

gen SELFY6= HQ015X+ HQ040X ;
gen LABY6= HQ020X+HQ045X+HQ025X+HQ050X+HQ030X+HQ055X+HQ035X+HQ060X;

gen otherassinc6= HQ381X; * income from “other assets” (does not match up with previous waves, but same as in wave 3); 


* generate the components of capy;
* interest, rent, dividends;

gen interestinc6= HQ143X; * rent;
replace interestinc6=interestinc6+HQ326X+HQ340X +HQ354X+HQ366X; *interest+dividends;
gen businc6= HQ157X ;
gen royaltyinc6= HQ386X; 
gen CAPY6=businc6+interestinc6+royaltyinc6;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
* Q5343Z+Q5364Z+Q5383Z: IRA withdraws;
* Q5397Z: IRA rolled over into an annuity;

gen peninc6= HQ121Z+HQ127Z+HQ220_1Z+HQ220_2Z +HQ246_1Z+HQ246_2Z; * note: Q5473
 should be included, but the mean of it is close to 0;
 
gen VAinc6 = HQ121Z+HQ127Z;

gen anninc6=HQ278_1Z+HQ278_2Z+HQ298_1Z+HQ298_2Z; * note: Q5506 should be included, but the mean of it is close to 0;

gen Socialinc6 = HQ085Z+HQ091Z;* note: these are total benes, includes DI;
gen PENY6=peninc6+anninc6;

gen SSIinc6= HQ107Z; 
gen WELFAREinc6= HQ115X;
gen unempinc6= HQ066X+HQ070X+HQ076X+HQ080X; 
gen DIinc6=0; * where is this variable?;
gen otherinc6= HQ391X+HQ396X; * the “other income” variable is the same as in wave 4;
gen SOCY6= DIinc6+Socialinc6;

gen OTHY6= unempinc6+ SSIinc6 + WELFAREinc6;

gen HHINCST6=LABY6+CAPY6+PENY6+OTHY6;
gen DIF6=faminc6-HHINCST6;

keep 
faminc6 SELFY6 LABY6 SOCY6 CAPY6 businc6 interestinc6 royaltyinc6 PENY6 peninc6 Socialinc6 anninc6 OTHY6 PENY6 unempinc6 SSIinc6 WELFAREinc6 VAinc6 DIinc6 otherinc6
DIF6 HHID PN HSUBHH;

summ;
drop DIF6;
sort HHID PN;
merge 1:1 HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;


************************** HRS WAVE VII **************************;

use `wave7d'H04A_R.dta; * get PN variable from the file;
global SUBHH "JSUBHH";
_getid_;
sort HHID JSUBHH;
egen group= group(HHID JSUBHH);
sort group;
by group: gen num=_N;
gen temp2=1;
replace temp2=0 if num==2 & (JFINR~=1);
sort HHID JSUBHH temp2;
save `wave7d'temp, replace;
drop _all;


use `wave7d'H04i_qh.dta;
gen temp2=1;
global SUBHH "JSUBHH";
_getid2_;
sort HHID JSUBHH temp2;
**one time fix for missing data issue**;
replace JSUBHH=1 if HHID==82694 & JSUBHH==7;
drop if HHID==87167 & JSUBHH==1;
replace JSUBHH=7 if HHID==87167 & JSUBHH==2;
replace JSUBHH=1 if HHID==204425 & JSUBHH==7;
**end of fix**;
merge 1:1 HHID JSUBHH temp2 using `wave7d'temp;
drop _merge temp2;


gen faminc7=JHHINC;

gen SELFY7= JQ015X+ JQ040X ;
gen LABY7= JQ020X+JQ045X+JQ025X+JQ050X+JQ030X+JQ055X+JQ035X+JQ060X;

gen otherassinc7= JQ381X; * income from “other assets” (does not match up with previous waves, but same as in wave 3); 


* generate the components of capy;
* interest, rent, dividends;

gen interestinc7= JQ143X; * rent;
replace interestinc7=interestinc7+JQ326X+JQ340X +JQ354X+JQ366X; *interest+dividends;
gen businc7= JQ157X ;

* trusts missing in wave 7;
gen royaltyinc7= 0; 

gen CAPY7=businc7+interestinc7+royaltyinc7;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
* Q5343Z+Q5364Z+Q5383Z: IRA withdraws;
* Q5397Z: IRA rolled over into an annuity;

gen peninc7= JQ121Z+JQ127Z+JQ220_1Z+JQ220_2Z +JQ246_1Z+JQ246_2Z; * note: Q5473
 should be included, but the mean of it is close to 0;

gen VAinc7 = JQ121Z+JQ127Z;

gen anninc7=JQ278_1Z+JQ278_2Z+JQ298_1Z+JQ298_2Z; * note: Q5506 should be included, but the mean of it is close to 0;

gen Socialinc7 = JQ085Z+JQ091Z;* note: these are total benes, includes DI;
gen PENY7=peninc7+anninc7;

gen SSIinc7= JQ107Z; 
gen WELFAREinc7= JQ115X;
gen unempinc7= JQ066X+JQ070X+JQ076X+JQ080X; 
gen DIinc7=0; * where is this variable?;

* alimony inc not included in wave 7;
gen otherinc7= JQ396X;

gen SOCY7= DIinc7+Socialinc7;

gen OTHY7= unempinc7+ SSIinc7 + WELFAREinc7;

gen HHINCST7=LABY7+CAPY7+PENY7+OTHY7;
gen DIF7=faminc7-HHINCST7;

keep 
faminc7 SELFY7 LABY7 SOCY7 CAPY7 businc7 interestinc7 royaltyinc7 PENY7 peninc7 Socialinc7 WELFAREinc7 VAinc7 anninc7 OTHY7 PENY7 unempinc7 SSIinc7 DIinc7 otherinc7
DIF7 HHID PN JSUBHH;

summ;
drop DIF7;
sort HHID; 
merge 1:1 HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;



************************** HRS WAVE VIII **************************;

use `wave8d'H06A_R; * get various demographics;

global SUBHH "KSUBHH";
_getid_;

keep PN KSUBHH HHID;

* generate placeholders;

gen faminc8=.;
gen SELFY8=.;
gen LABY8=.;
gen SOCY8=.;
gen CAPY8=.;
gen businc8=.;
gen interestinc8=.; 
gen royaltyinc8=.;
gen PENY8=.;
gen peninc8=.;
gen Socialinc8=.;
gen anninc8=.;
gen OTHY8=.;
gen unempinc8=.;
gen SSIinc8=.;
gen WELFAREinc8=.;
gen DIinc8=.;
gen otherinc8=.;
gen DIF8=.;
gen VAinc8=.;

summ;
drop DIF8;
sort HHID PN; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE IX **************************;

use `wave9d'H08A_R; * get various demographics;

global SUBHH "LSUBHH";
_getid_;

keep PN LSUBHH HHID;

* generate placeholders;

gen faminc9=.;
gen SELFY9=.;
gen LABY9=.;
gen SOCY9=.;
gen CAPY9=.;
gen businc9=.;
gen interestinc9=.; 
gen royaltyinc9=.;
gen PENY9=.;
gen peninc9=.;
gen Socialinc9=.;
gen anninc9=.;
gen OTHY9=.;
gen unempinc9=.;
gen SSIinc9=.;
gen WELFAREinc9=.;
gen DIinc9=.;
gen otherinc9=.;
gen DIF9=.;
gen VAinc9=.;

summ;
drop DIF9;
sort HHID PN; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE X **************************;

use `wave10d'H10A_R; * get various demographics;

global SUBHH "MSUBHH";
_getid_;

keep PN MSUBHH HHID;

* generate placeholders;

gen faminc10=.;
gen SELFY10=.;
gen LABY10=.;
gen SOCY10=.;
gen CAPY10=.;
gen businc10=.;
gen interestinc10=.; 
gen royaltyinc10=.;
gen PENY10=.;
gen peninc10=.;
gen Socialinc10=.;
gen anninc10=.;
gen OTHY10=.;
gen unempinc10=.;
gen SSIinc10=.;
gen WELFAREinc10=.;
gen DIinc10=.;
gen otherinc10=.;
gen DIF10=.;
gen VAinc10=.;

summ;
drop DIF10;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;


************************** HRS WAVE 11  **************************;

use `wave11d'H12A_R; * get various demographics;

global SUBHH "NSUBHH";
_getid_;

keep PN NSUBHH HHID;

* generate placeholders;

gen faminc11=.;
gen SELFY11=.;
gen LABY11=.;
gen SOCY11=.;
gen CAPY11=.;
gen businc11=.;
gen interestinc11=.; 
gen royaltyinc11=.;
gen PENY11=.;
gen peninc11=.;
gen Socialinc11=.;
gen anninc11=.;
gen OTHY11=.;
gen unempinc11=.;
gen SSIinc11=.;
gen WELFAREinc11=.;
gen DIinc11=.;
gen otherinc11=.;
gen DIF11=.;
gen VAinc11=.;

summ;
drop DIF11;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;


************************** HRS WAVE 12  **************************;

use `wave12d'H14A_R; * get various demographics;

global SUBHH "OSUBHH";
_getid_;

keep PN OSUBHH HHID;

* generate placeholders;

gen faminc12=.;
gen SELFY12=.;
gen LABY12=.;
gen SOCY12=.;
gen CAPY12=.;
gen businc12=.;
gen interestinc12=.; 
gen royaltyinc12=.;
gen PENY12=.;
gen peninc12=.;
gen Socialinc12=.;
gen anninc12=.;
gen OTHY12=.;
gen unempinc12=.;
gen SSIinc12=.;
gen WELFAREinc12=.;
gen DIinc12=.;
gen otherinc12=.;
gen DIF12=.;
gen VAinc12=.;

summ;
drop DIF12;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;


************************** HRS WAVE 13  **************************;

use `wave13d'H16A_R; * get various demographics;

global SUBHH "PSUBHH";
_getid_;

keep PN PSUBHH HHID;

* generate placeholders;

gen faminc13=.;
gen SELFY13=.;
gen LABY13=.;
gen SOCY13=.;
gen CAPY13=.;
gen businc13=.;
gen interestinc13=.; 
gen royaltyinc13=.;
gen PENY13=.;
gen peninc13=.;
gen Socialinc13=.;
gen anninc13=.;
gen OTHY13=.;
gen unempinc13=.;
gen SSIinc13=.;
gen WELFAREinc13=.;
gen DIinc13=.;
gen otherinc13=.;
gen DIF13=.;
gen VAinc13=.;

summ;
drop DIF13;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE 14  **************************;

use `wave14d'H18A_R; * get various demographics;
rename hhid HHID;
rename pn PN;
rename qsubhh QSUBHH ;
rename psubhh PSUBHH ;
global SUBHH "QSUBHH";
_getid_;

keep PN QSUBHH HHID;

* generate placeholders;

gen faminc14=.;
gen SELFY14=.;
gen LABY14=.;
gen SOCY14=.;
gen CAPY14=.;
gen businc14=.;
gen interestinc14=.; 
gen royaltyinc14=.;
gen PENY14=.;
gen peninc14=.;
gen Socialinc14=.;
gen anninc14=.;
gen OTHY14=.;
gen unempinc14=.;
gen SSIinc14=.;
gen WELFAREinc14=.;
gen DIinc14=.;
gen otherinc14=.;
gen DIF14=.;
gen VAinc14=.;

summ;
drop DIF14;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;

************************** HRS WAVE 15  **************************;
if $INCLUDE2020 {; 
disp "Doing 2020 processing..." ;
use `wave15d'H20A_R; * get various demographics;
rename hhid HHID;
rename pn PN;
rename qsubhh QSUBHH ;
rename rsubhh RSUBHH ;
global SUBHH "RSUBHH";
_getid_;

keep PN RSUBHH HHID;

* generate placeholders;

gen faminc15=.;
gen SELFY15=.;
gen LABY15=.;
gen SOCY15=.;
gen CAPY15=.;
gen businc15=.;
gen interestinc15=.; 
gen royaltyinc15=.;
gen PENY15=.;
gen peninc15=.;
gen Socialinc15=.;
gen anninc15=.;
gen OTHY15=.;
gen unempinc15=.;
gen SSIinc15=.;
gen WELFAREinc15=.;
gen DIinc15=.;
gen otherinc15=.;
gen DIF15=.;
gen VAinc15=.;

summ;
drop DIF15;
sort HHID PN ; 
merge HHID PN using `saved'income;
drop _merge;
sort HHID PN;
sleep 500; save `saved'income, replace;
drop _all;
};

************************** AHEAD WAVE I **************************;

use `aheadw1'br21.dta; * Labor income stored separately;
gen temp=real(PN); 
drop PN; 
rename temp PN; 
tabulate PN;
drop if PN==20; *Save one spouse's labor income;
rename V1178 SELFm;
replace JOBLCYX=0 if JOBLCYX==.;
keep HHID BSUBHH SELFm JOBLCYX V1189X; 
sort HHID BSUBHH;  
save `aheadw1'temp, replace;
drop _all;

use `aheadw1'br21.dta; *Now save second person's labor income;
gen temp=real(PN); 
drop PN; 
rename temp PN; 
drop if PN==10; 
rename V1178 SELFw;
replace JOBLCYX=0 if JOBLCYX==.;
rename JOBLCYX joblcyz;
rename V1189X V1189z;
keep HHID BSUBHH SELFw joblcyz V1189z; 
sort HHID BSUBHH;  
merge HHID BSUBHH using `aheadw1'temp;
drop _merge;
summ HHID j* V*;
sort HHID BSUBHH;
save `aheadw1'temp, replace;
drop _all;

* Labor income now stored just by HHID SUBHH;
* Give each member of the SUBHH total labor income;
use `aheadw1'br21.dta; * get PN variable from the file;
keep HHID PN BSUBHH;

sort HHID BSUBHH; 
merge HHID BSUBHH using `aheadw1'temp;
drop _merge;
sort HHID BSUBHH; 
save `aheadw1'temp, replace;
drop _all;

use `aheadw1'bhh21.dta;
sort HHID BSUBHH;  
merge HHID BSUBHH using `aheadw1'temp;
drop _merge;

replace V1379X=0 if V1379X==.;
replace V1390X=0 if V1390X==.;
replace V1414X=0 if V1414X==.;
replace V1460X=0 if V1460X==.;
replace V1478X=0 if V1478X==.;
replace V1495X=0 if V1495X==.;
replace V1520X=0 if V1520X==.;
replace V1542X=0 if V1542X==.;
replace V1563X=0 if V1563X==.;
replace V1587X=0 if V1587X==.;
replace V1593X=0 if V1593X==.;
replace V1606X=0 if V1606X==.;
replace V1618X=0 if V1618X==.;
replace V1630X=0 if V1630X==.;
replace V1189X=0 if V1189X==.;
replace V1189z=0 if V1189z==.;
replace JOBLCYX=0 if JOBLCYX==.;
replace joblcyz=0 if joblcyz==.;



**********TO GENERATE PENY,CAPY,OTHY USING V1457,V1475,V1492,V1517,V1539,V1560**************;
gen V1460XPR1=0;gen V1460XCR1=0;gen V1460XOR1=0; gen V1460XAR1=0;
gen V1478XPR2=0;gen V1478XCR2=0;gen V1478XOR2=0; gen V1478XAR2=0;
gen V1495XPR3=0;gen V1495XCR3=0;gen V1495XOR3=0; gen V1495XAR3=0;
gen V1520XPS1=0;gen V1520XCS1=0;gen V1520XOS1=0; gen V1520XAS1=0;
gen V1542XPS2=0;gen V1542XCS2=0;gen V1542XOS2=0; gen V1542XAS2=0;
gen V1563XPS3=0;gen V1563XCS3=0;gen V1563XOS3=0; gen V1563XAS3=0;
gen V1460XVR1=0; gen V1478XVR2=0; gen V1495XVR3=0; gen V1520XVS1=0;
gen V1542XVS2=0; gen V1563XVS3=0;
**************************;
* legend for V1457        ;
* 1 --> veterans benes     ;
* 2 --> pension            ;
* 3 --> annuity            ;
* 4 --> IRA distribution   ;
* 5 --> stocks and bonds   ;
* 6 --> job                ;
* 7 --> other (could be business?) ;
**************************;

replace V1460XPR1=V1460X if (V1457==1)|(V1457==2)|(V1457==6);
replace V1460XAR1=V1460X if (V1457==3);
replace V1460XCR1=V1460X if (V1457==5);
replace V1460XOR1=V1460X if (V1457==7)|(V1457==.);
replace V1478XPR2=V1478X if (V1475==1)|(V1475==2)|(V1475==6);
replace V1478XAR2=V1478X if (V1475==3);
replace V1478XCR2=V1478X if (V1475==5);
replace V1478XOR2=V1478X if (V1475==7)|(V1475==.);
replace V1495XPR3=V1495X if (V1492==1)|(V1492==2)|(V1492==6); 
replace V1495XAR3=V1495X if (V1492==3);
replace V1495XCR3=V1495X if (V1492==5);
replace V1495XOR3=V1495X if (V1492==7)|(V1492==.);
replace V1520XPS1=V1520X if (V1517==1)|(V1517==2)|(V1517==6); 
replace V1520XAS1=V1520X if (V1517==3);
replace V1520XCS1=V1520X if (V1517==5);
replace V1520XOS1=V1520X if (V1517==7)|(V1517==.);
replace V1542XPS2=V1542X if (V1539==1)|(V1539==2)|(V1539==6); 
replace V1542XAS2=V1542X if (V1539==3);
replace V1542XCS2=V1542X if (V1539==5);
replace V1542XOS2=V1542X if (V1539==7)|(V1539==.);
replace V1563XPS3=V1563X if (V1560==1)|(V1560==2)|(V1560==6);
replace V1563XAS3=V1563X if (V1560==3);
replace V1563XCS3=V1563X if (V1560==5);
replace V1563XOS3=V1563X if (V1560==7)|(V1560==.); 

*to calculate veterans benefits

replace V1460XVR1=V1460X if V1457==1
replace V1478XVR2=V1478X if V1475==1
replace V1495XVR3=V1495X if V1492==1
replace V1520XVS1=V1520X if V1517==1
replace V1542XVS2=V1542X if V1539==1
replace V1563XVS3=V1563X if V1560==1

******************;


gen otherassincA1= 0; * income from “other assets” (does not match up with previous waves, but same as in wave 3); 


* generate the components of capy;
* interest, rent, dividends;

gen interestincA1=V1478XCR2+V1495XCR3+V1520XCS1+V1542XCS2+V1563XCS3+V1587X+V1593X ; 
gen busincA1= V1460XOR1+V1478XOR2+V1495XOR3+V1520XOS1+V1542XOS2+V1563XOS3 ;* not clear what this stuff is—listed as “other”;
gen royaltyincA1= 0; 
gen CAPYA1=busincA1+interestincA1+royaltyincA1;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
* IRA withdraws: V1542X, V1563, etc=4;
* IRA rolled over into an annuity;

gen penincA1= V1460XPR1+V1478XPR2+V1495XPR3+V1520XPS1+V1542XPS2+V1563XPS3;
gen VAincA1= V1460XVR1+V1478XVR2+V1495XVR3+V1520XVS1+V1542XVS2+V1563XVS3;
gen annincA1= V1460XAR1+V1478XAR2+V1495XAR3+V1520XAS1+V1542XAS2+V1563XAS3;

gen SocialincA1= 0;
replace SocialincA1= V1379X if V1378~=3;
replace SocialincA1= SocialincA1+V1390X if V1389~=3;

gen DIincA1=0; 
replace DIincA1= V1379X if V1378==3;
replace DIincA1= DIincA1+V1390X if V1389==3;

gen PENYA1 =penincA1+annincA1;

sum V1414X V1432X;
replace V1432X=0 if V1432X==.;

gen SSIincA1= V1414X;
gen WELFAREincA1= .;
gen unempincA1= 0; * relevant for this cohort?; 
* otherincA1 may be better thought of as business income, royalties, interest;
gen otherincA1=0;
gen SOCYA1= DIincA1+SocialincA1;
gen OTHYA1= unempincA1+ SSIincA1;

summ PENYA1 CAPYA1 OTHYA1;


gen SELFYA1=0;
gen LABYA1=0;
replace LABYA1= JOBLCYX if SELFm==1;
replace SELFYA1= JOBLCYX if SELFm==2;

replace LABYA1=LABYA1+joblcyz if SELFw==1;
replace SELFYA1=SELFYA1+JOBLCYX if SELFw==2;

gen faminca1 = LABYA1+PENYA1+CAPYA1+OTHYA1;
gen DIFA1 = V1648X-faminca1; *V1648X is NOT a sum, so these 2 need not match;
keep 
faminca1 SELFYA1 SOCYA1 LABYA1 CAPYA1 busincA1 interestincA1 royaltyincA1 PENYA1 penincA1 VAincA1 SocialincA1 annincA1 OTHYA1 PENYA1 unempincA1 SSIincA1 DIincA1 otherincA1
HHID PN BSUBHH V1648X DIFA1;

summ;
drop V1648X DIFA1;
destring HHID, replace;
destring PN, replace;
sort HHID PN;
save `aheadw1'income,replace;
drop _all;

************************** AHEAD WAVE II **************************;

use `aheadw2'A95CS_R.dta; * get PN from the cover-screen data file;
rename DSUBHH GSUBHH;
global SUBHH "GSUBHH";
_getid_;
rename GSUBHH DSUBHH;
sort HHID DSUBHH;
save `aheadw2'temp, replace;
drop _all;

use `aheadw2'A95J_H.dta;
global SUBHH "DSUBHH";
_getid2_;
sort HHID DSUBHH;
save `aheadw2'tempx, replace;
drop _all;


use `aheadw2'a95i_jh.dta; *Jon: I could not find DHHINC in any of the updated datasets. ;
global SUBHH "DSUBHH";
_getid2_;
sort HHID DSUBHH;
merge HHID DSUBHH using `aheadw2'temp;
drop _merge;
sort HHID DSUBHH;
merge HHID DSUBHH using `aheadw2'tempx;
drop _merge;


gen faminca2=DHHINC;
gen SELFYA2= D4536_1X + D4549_1X ;
gen LABYA2= D4536_2X+D4536_3X+D4536_4X+D4549_2X+D4549_3X+D4549_4X;

gen otherassincA2= D4518X; * variable is same as later waves of HRS;

* generate the components of capy;
* interest, rent, dividends;

gen interestincA2= D3987X; * rental;
replace interestincA2=interestincA2+D4361X+D4404X+D4444X+D4486X; * interest and dividends; 
gen busincA2= D4029X  ;
gen royaltyincA2= D4563X; 
gen CAPYA2=interestincA2+busincA2+royaltyincA2;

* JUNK THAT SHOULD NOT HAVE BEEN INCLUDED;
* IRA withdraws : D4079Z+D4117Z;
* IRA rolled over into an annuity;

gen penincA2= D3937Z+D3950Z+D4198Z+D4213Z+D4229Z+D4238Z;
gen VAincA2 = D3937Z+D3950Z;
gen annincA2= D4271Z+D4285Z+ (D4294X*12)+ D4302Z +D4315Z+ (D4324X*12); *first two pensions are annualized, third is not;

gen SocialincA2= 0;
replace SocialincA2= D3878Z if D3877M1~=2;
replace SocialincA2= SocialincA2+D3888Z if D3886M1~=2;

gen DIincA2=0; 
replace DIincA2= D3878Z if D3877M1==2;
replace DIincA2= DIincA2+D3888Z if D3886M1==2;;


gen PENYA2 =penincA2+annincA2;

gen SSIincA2= D3912Z;
gen WELFAREincA2= D3929X;
gen unempincA2= 0; // relevant for this cohort?; 
gen otherincA2= D4567X+D4574X; * comparable to later HRS waves;
gen SOCYA2= DIincA2+SocialincA2;
gen OTHYA2= unempincA2+ SSIincA2 +WELFAREincA2;
gen HHINCSTA2=LABYA2+CAPYA2+PENYA2+OTHYA2;
gen DIFA2=faminca2-HHINCSTA2;
keep 
HHINCSTA2 faminca2 SELFYA2 SOCYA2 LABYA2 CAPYA2 busincA2 interestincA2 royaltyincA2 PENYA2 penincA2 SocialincA2 annincA2 OTHYA2 PENYA2 unempincA2 SSIincA2 WELFAREincA2 VAincA2 DIincA2 otherincA2
HHID PN BSUBHH DIFA2 DSUBHH;
summ;
drop DIFA2;
sort HHID PN;
merge HHID PN using `aheadw1'income;
drop _merge;

sort HHID PN;
save `aheadw2'income,replace; 
drop _all;

*************** merge AHEAD data to HRS data ******************;

use `saved'income;
sort HHID PN;
merge HHID PN using `aheadw2'income;
drop _merge;
summ HHID PN *SUBHH faminc* LABY* CAPY* PENY* OTHY*;

* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE II values;

replace faminc1=faminca1 if faminc1==. & faminca1~=.;
replace faminc2=faminca2 if faminc2==. & faminca2~=.;
replace LABY1=LABYA1 if LABY1==. & LABYA1 ~=.;
replace SELFY1=SELFYA1 if SELFY1==. & SELFYA1 ~=.;
replace SOCY1=SOCYA1 if SOCY1==. & SOCYA1 ~=.;
replace CAPY1=CAPYA1 if CAPY1==. & CAPYA1 ~=.;
replace PENY1=PENYA1 if PENY1==. & PENYA1 ~=.;
replace OTHY1=OTHYA1 if OTHY1==. & OTHYA1 ~=.;
replace LABY2=LABYA2 if LABY2==. & LABYA2 ~=.;
replace SELFY2=SELFYA2 if SELFY2==. & SELFYA2 ~=.;
replace SOCY2=SOCYA2 if SOCY2==. & SOCYA2 ~=.;
replace CAPY2=CAPYA2 if CAPY2==. & CAPYA2 ~=.;
replace PENY2=PENYA2 if PENY2==. & PENYA2 ~=.;
replace OTHY2=OTHYA2 if OTHY2==. & OTHYA2 ~=.;

* components of CAPY;
replace interestinc1=interestincA1 if interestinc1==. & interestincA1~=.;
replace royaltyinc1=royaltyincA1 if royaltyinc1==. & royaltyincA1~=.;
replace businc1=busincA1 if businc1==. & busincA1~=.;
* PENY;
replace peninc1=penincA1 if peninc1==. & penincA1~=.;
replace anninc1=annincA1 if anninc1==. & annincA1~=.;
* OTHY;
replace SSIinc1=SSIincA1 if SSIinc1==. & SSIincA1~=.;
replace unempinc1=unempincA1 if unempinc1==. & unempincA1~=.;
replace otherinc1=otherincA1 if otherinc1==. & otherincA1~=.;
*VA;
replace VAinc1=VAincA1 if VAinc1==. & VAincA1~=.;


* components of CAPY;
replace interestinc2=interestincA2 if interestinc2==. & interestincA2~=.;
replace royaltyinc2=royaltyincA2 if royaltyinc2==. & royaltyincA2~=.;
replace businc2=busincA2 if businc2==. & busincA2~=.;
* PENY;
replace peninc2=penincA2 if peninc2==. & penincA2~=.;
replace anninc2=annincA2 if anninc2==. & annincA2~=.;
* OTHY;
replace SSIinc2=SSIincA2 if SSIinc2==. & SSIincA2~=.;
replace WELFAREinc2 = WELFAREincA2 if WELFAREinc2==. & WELFAREincA2~=.;
replace unempinc2=unempincA2 if unempinc2==. & unempincA2~=.;
replace otherinc2=otherincA2 if otherinc2==. & otherincA2~=.;
* VA;
replace VAinc2=VAincA2 if VAinc2==. & VAincA2~=.;


drop faminca1 faminca2 *A1 *A2;

summ HHID PN *SUBHH faminc* LABY* CAPY* PENY* OTHY* SELFY* SOCY*;


program define namer;
	version 6.0;

	local i=k;
rename LABY`i' laby`i';
rename CAPY`i' capy`i';
rename OTHY`i' othy`i';
rename PENY`i' peny`i';
rename SOCY`i' socy`i';
rename SELFY`i' selfy`i';
	end;

gen k=1;
namer;
replace k=2;
namer;
replace k=3;
namer;
replace k=4;
namer;
replace k=5;
namer;
replace k=6;
namer;
replace k=7;
namer;
replace k=8;
namer;
replace k=9;
namer;
replace k=10;
namer;
replace k=11;
namer;
replace k=12;
namer;
replace k=13;
namer;
replace k=14;
namer;
if $INCLUDE2020 {; 
replace k=15;
namer;
drop k;
};
sort HHID PN;
sleep 500; save `saved'income, replace;

*drop _all;
program drop _all;
log close;

* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(income.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'income.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(income.xlsx) sheetname(Old);



/* 

Eric's question:

I am trying to generate a variable for Disability Insurance benefits 
across waves.  I have been unable to locate this variable in HRS waves 
3-5.  My impression is that the variables E3985Z and E3996Z are for total 
Social Security income in wave 3, including DI.  However, I have not been 
able to figure out whether  people obtain Social Security benefits through 
DI or OASI.  Does such a variable exist?


HRS answer:

--------
Answer for Question 2   


In the income section in both 1992 and 1994, we ask the FKR about
* own receipt of SSI (and, if so, how much)
* spouse receipt of SSI (and, if so, how much)
* own receipt of Social Security (if so, whether due to disability, and how
much
* spouse receipt of Social Security (if so, whether due to disability, and
how much)


In 1996 we ask about SSI and Social Security, but not why R is receiving SS.
I do not have any recollection of why we changed (I have not been much
involved in the income section's decisions).


However, the disabilty section asks whether R is receiving SSI or SSDI, so
we have some indication of whether the SS in the income section could be
SSDI.


We also asked about SSI in the income/assets section.




Income Section


HRS 1996
--------------------------------------------
E3985     J47.R AMT RECVD SS LAST MO
E3996     J50A1.SP HOW MUCH SS BENEFITS


E4021     J59.R/S SSI-LAST MONTH
E4023     J61.R/S SSI $ (amount)



HRS 1998
--------------------------------------------
F4745     J47.R AMT RECVD SS LAST MO
F4756     J50A1.SP HOW MUCH SS BENEFITS


F4781     J59.R/S SSI-LAST MONTH
F4783     J61.R/S SSI $ (amount)




HRS 2000
---------------------------------------------
G5186     J47.R AMT RECVD SS LAST MO
G5199     J50A1.SP HOW MUCH SS BENEFITS


G5224     J59.R/S SSI-LAST MONTH
G5226     J61.R/S SSI $ (amount)




Disability Benefits 


HRS 1996


Section GD (Disablitity variables, no amount variables)
-------------------------------------------------------
E3589     GD23. APPLY OTHER DISABILITY
E3595M1/M3   GD24. DISABILITY PROGRAMS
E3614     GD26J. SS-STILL RECEIVING




HRS 1998


Section GD, GJ (Disablititys, no amount variables)
--------------------------------------------------
F408k8     GD18. RECEIVE SSD/SSI
F4091     GD18C.PRIOR WAVE APPLIED FOR SSDI/SSI
F4097     GD18G.STILL RECEIVING BENEFITS
F4488M1/M5   GJ122.GOVERNMENT PROGRAMS KNOWN
F4489     GJ123.EVER APPLY FOR SSD OR SSI
F4492     GJ123B.SS AWARDED BENEFITS
F4496     GJ123E.SS AWARDED THEN
F4502     GJ123J.STILL RECEIVING BENEFITS



HRS 2000
Section GD, GJ (Disablititys & Amount variables)
----------------------------------------------------------------------------
------------------
G4373     GD18. RECEIVE SSD/SSI                 G4375     GD18AB. SSDI
AMOUNT REC`D
G4383     GD18BA. REC`D SSI BENEFITS            G4384     GD18BB. SSI AMOUNT
REC`D
G4396     GD18CG.STILL RECEIVING SSDI BENEFITS  G4397     GD18CH. SSDI
AMOUNT REC`D
G4409     GD18DK.STILL RECEIVING SSDI BENEFITS  G4410     GD18DM. SSDI
AMOUNT REC`D
G4416     GD18ED.STILL RECEIVING SSI BENEFITS   G4417     GD18EE. SSI AMOUNT
REC`D
G4426     GD18EQ.STILL RECEIVING SSI BENEFITS   G4427     GD18ER. SSI AMOUNT
REC`D
G4466     GD26G.SSD-STILL RECEIVING             G4467     GD26H.SSD AMOUNT
REC`D
G4484     GD27G. SSI-STILL RECEIVING            G4485     GD27H.SSI AMOUNT
REC`D
G4875     GJ123J.STILL RECEIVING BENEFITS       G4876     GJ123JA. SSDI
BENEFITS AMOUNT REC`D
G4894     GJ125G.STILL RECEIVING BENEFITS       G4895     GJ125H. SSI
BENEFITS AMOUNT REC`D



> ----------------------------------------------
> HRS 1996 -
> E4021     J59.R/S SSI-LAST MONTH
> E4023     J61.R/S SSI $ (amount)
>
> HRS 1998 -
> F4781     J59.R/S SSI-LAST MONTH
> F4783     J61.R/S SSI $ (amount)
>
> HRS 2000 -
> G5224     J59.R/S SSI-LAST MONTH
> G5226     J61.R/S SSI $ (amount)
>
> ----------------------------------------------
>
> **********************************************************************


> HRS 1996
> Section J  SS (amount variables)
>
> -----------------------------------------------------------------
> E3985     J47.R AMT RECVD SS LAST MO
> E3996     J50A1.SP HOW MUCH SS BENEFITS
>
> Section GD (Disablitity variables, no amount variables)
> -----------------------------------------------------------------
> E3589     GD23. APPLY OTHER DISABILITY
> E3595M1/M3   GD24. DISABILITY PROGRAMS
> E3614     GD26J. SS-STILL RECEIVING
>
>
>
> HRS 1998
> Section J  SS (amount variables)
>
> ---------------------------------------------------------
> F4745     J47.R AMT RECVD SS LAST MO
> F4756     J50A1.SP HOW MUCH SS BENEFITS
>
> Section GD, GJ (Disablititys, no amount variables)
> --------------------------------------------------------------------
> F408k8     GD18. RECEIVE SSD/SSI
> F4091     GD18C.PRIOR WAVE APPLIED FOR SSDI/SSI
> F4097     GD18G.STILL RECEIVING BENEFITS
> F4488M1/5   GJ122.GOVERNMENT PROGRAMS KNOWN
> F4489     GJ123.EVER APPLY FOR SSD OR SSI
> F4492     GJ123B.SS AWARDED BENEFITS
> F4496     GJ123E.SS AWARDED THEN
> F4502     GJ123J.STILL RECEIVING BENEFITS
>
>
> HRS 2000Section J  SS (amount variables)
>
> ---------------------------------------------------------
> G5186     J47.R AMT RECVD SS LAST MO
> G5199     J50A1.SP HOW MUCH SS BENEFITS
>
> Section GD, GJ (Disablititys & Amount variables)
> ----------------------------------------------------------------------
> ------
> ----------------------------------------
> G4373     GD18. RECEIVE SSD/SSI                       G4375     GD18AB.
SSDI
> AMOUNT REC`D
> G4383     GD18BA. REC`D SSI BENEFITS          G4384     GD18BB. SSI AMOUNT
> REC`D
> G4396     GD18CG.STILL RECEIVING SSDI BENEFITS        G4397     GD18CH.
SSDI
> AMOUNT REC`D
> G4409     GD18DK.STILL RECEIVING SSDI BENEFITS        G4410     GD18DM.
SSDI
> AMOUNT REC`D
> G4416     GD18ED.STILL RECEIVING SSI BENEFITS G4417     GD18EE. SSI AMOUNT
> REC`D
> G4426     GD18EQ.STILL RECEIVING SSI BENEFITS G4427     GD18ER. SSI AMOUNT
> REC`D
> G4466     GD26G.SSD-STILL RECEIVING           G4467     GD26H.SSD AMOUNT
> REC`D
> G4484     GD27G. SSI-STILL RECEIVING          G4485     GD27H.SSI AMOUNT
> REC`D
> G4875     GJ123J.STILL RECEIVING BENEFITS             G4876     GJ123JA.
> SSDI BENEFITS AMOUNT REC`D
> G4894     GJ125G.STILL RECEIVING BENEFITS     G4895     GJ125H. SSI
> BENEFITS AMOUNT REC`D
>
> **********************************************************************



*/
